﻿using System;
using System.ComponentModel;
using System.Net;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace WP7CodingCampMVVM
{
    public class PersonViewModel : INotifyPropertyChanged
    {
        #region Field

        private Person _model;

        #endregion

        #region Constructor

        public PersonViewModel(Person person )
        {
            _model = person;
        }

        #endregion

        #region Properties

        public string Name
        {
            get
            {
                return _model.Name;
            }
            set
            {
                _model.Name = value;
                RaisePropertyChanged("Name");
                RaisePropertyChanged("Summary");
            }
        }

        public string Address
        {
            get
            {
                return _model.Address;
            }
            set
            {
                _model.Address = value;
                RaisePropertyChanged("Address");
                //RaisePropertyChanged("Summary");
            }
        }

        public string Type
        {
            get
            {
                switch (_model.Type)
                {
                    case AddressType.Business:
                        return "Geschäftlich";
                    case AddressType.Private:
                        return "Privat";
                    default:
                        return "Nicht gewählt";
                }
            }
            set
            {
                
            }
        }

        public string Summary
        {
            get
            {
                StringBuilder sb = new StringBuilder();
                sb.AppendLine(Name);
                sb.AppendLine(Address);
                sb.AppendLine(Type);

                return sb.ToString();
            }
        }


        #endregion

        #region Implementation of INotifyPropertyChanged

        public event PropertyChangedEventHandler PropertyChanged;

        private void RaisePropertyChanged(string name)
        {
            PropertyChangedEventHandler handler = PropertyChanged;

            if(handler != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(name));
            }

        }


        #endregion
    }
}
